<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class PlanExpiryCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'expiry:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Reminder intervals (fetch from settings or define statically)
        $reminderDays = DB::table('config')->get()[60]->config_value;

        // Convert to array
        $reminderDays = explode(',', $reminderDays);
        $reminderDays = array_map('intval', $reminderDays);

        $currentDate = Carbon::now();

        foreach ($reminderDays as $daysBefore) {
            // Calculate target expiry range
            $expiryDate = $currentDate->copy()->addDays($daysBefore);

            // Get users whose plans expire on the target date
            $users = DB::table('users')
                ->where('status', 1)
                ->whereDate('plan_validity', $expiryDate)
                ->get();

            if ($users->isEmpty()) {
                // $this->info("No users found for reminders {$daysBefore} days before expiry.");
                continue;
            }

            foreach ($users as $user) {
                $details = [
                    'name' => $user->name,
                    'email' => $user->email,
                ];

                // Send email
                try {
                    // Check $daysBefore is below 0
                    if ($daysBefore <= 0) {
                        Mail::to($user->email)->send(new \App\Mail\ExpiredPlanMail($details));
                        // $this->info("Reminder email sent to {$user->email} ({$daysBefore} days before expiry)");
                    } else {
                        Mail::to($user->email)->send(new \App\Mail\ExpiryPlanMail($details));
                        // $this->info("Reminder email sent to {$user->email} ({$daysBefore} days before expiry)");
                    }
                } catch (\Exception $e) {
                    // $this->error("Failed to send email to {$user->email}: {$e->getMessage()}");
                }
            }
        }
    }
}
