<?php

namespace App\Services;

use Pusher\PushNotifications\PushNotifications;

class PusherBeamsService
{
    protected $beamsClient;

    public function __construct()
    {
        $this->beamsClient = new PushNotifications([
            'instanceId' => config('services.beams.instance_id'),
            'secretKey'  => config('services.beams.secret_key'),
        ]);
    }

    /**
     * Send a notification to all devices subscribed to an interest.
     *
     * @param string $interest
     * @param array $notification
     * @return mixed
     */
    public function broadcastToInterest(string $interest, array $notification)
    {
        return $this->beamsClient->publishToInterests(
            [$interest],
            [
                'web' => [
                    'notification' => $notification,
                ],
            ]
        );
    }
}
