<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CurrencyTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('currencies')->truncate();

        DB::table('currencies')->insert(array(array('priority'=>'100',
                       'iso_code'=>'AED',
                       'name'=>'United Arab Emirates Dirham',
                       'symbol'=>'د.إ',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'784'),
                    array('priority'=>'100',
                       'iso_code'=>'AFN',
                       'name'=>'Afghan Afghani',
                       'symbol'=>'؋',
                       'subunit'=>'Pul',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'971'),
                    array('priority'=>'100',
                       'iso_code'=>'ALL',
                       'name'=>'Albanian Lek',
                       'symbol'=>'L',
                       'subunit'=>'Qintar',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'008'),
                    array('priority'=>'100',
                       'iso_code'=>'AMD',
                       'name'=>'Armenian Dram',
                       'symbol'=>'դր.',
                       'subunit'=>'Luma',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'051'),
                    array('priority'=>'100',
                       'iso_code'=>'ANG',
                       'name'=>'Netherlands Antillean Gulden',
                       'symbol'=>'ƒ',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x0192;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'532'),
                    array('priority'=>'100',
                       'iso_code'=>'AOA',
                       'name'=>'Angolan Kwanza',
                       'symbol'=>'Kz',
                       'subunit'=>'Cêntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'973'),
                    array('priority'=>'100',
                       'iso_code'=>'ARS',
                       'name'=>'Argentine Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'032'),
                    array('priority'=>'4',
                       'iso_code'=>'AUD',
                       'name'=>'Australian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'036'),
                    array('priority'=>'100',
                       'iso_code'=>'AWG',
                       'name'=>'Aruban Florin',
                       'symbol'=>'ƒ',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x0192;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'533'),
                    array('priority'=>'100',
                       'iso_code'=>'AZN',
                       'name'=>'Azerbaijani Manat',
                       'symbol'=>'null',
                       'subunit'=>'Qəpik',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'944'),
                    array('priority'=>'100',
                       'iso_code'=>'BAM',
                       'name'=>'Bosnia and Herzegovina Convertible Mark',
                       'symbol'=>'КМ',
                       'subunit'=>'Fening',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'977'),
                    array('priority'=>'100',
                       'iso_code'=>'BBD',
                       'name'=>'Barbadian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'052'),
                    array('priority'=>'100',
                       'iso_code'=>'BDT',
                       'name'=>'Bangladeshi Taka',
                       'symbol'=>'৳',
                       'subunit'=>'Paisa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'050'),
                    array('priority'=>'100',
                       'iso_code'=>'BGN',
                       'name'=>'Bulgarian Lev',
                       'symbol'=>'лв',
                       'subunit'=>'Stotinka',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'975'),
                    array('priority'=>'100',
                       'iso_code'=>'BHD',
                       'name'=>'Bahraini Dinar',
                       'symbol'=>'ب.د',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'048'),
                    array('priority'=>'100',
                       'iso_code'=>'BIF',
                       'name'=>'Burundian Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'108'),
                    array('priority'=>'100',
                       'iso_code'=>'BMD',
                       'name'=>'Bermudian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'060'),
                    array('priority'=>'100',
                       'iso_code'=>'BND',
                       'name'=>'Brunei Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Sen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'096'),
                    array('priority'=>'100',
                       'iso_code'=>'BOB',
                       'name'=>'Bolivian Boliviano',
                       'symbol'=>'Bs.',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'068'),
                    array('priority'=>'100',
                       'iso_code'=>'BRL',
                       'name'=>'Brazilian Real',
                       'symbol'=>'R$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'R$',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'986'),
                    array('priority'=>'100',
                       'iso_code'=>'BSD',
                       'name'=>'Bahamian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'044'),
                    array('priority'=>'100',
                       'iso_code'=>'BTN',
                       'name'=>'Bhutanese Ngultrum',
                       'symbol'=>'Nu.',
                       'subunit'=>'Chertrum',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'064'),
                    array('priority'=>'100',
                       'iso_code'=>'BWP',
                       'name'=>'Botswana Pula',
                       'symbol'=>'P',
                       'subunit'=>'Thebe',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'072'),
                    array('priority'=>'100',
                       'iso_code'=>'BYR',
                       'name'=>'Belarusian Ruble',
                       'symbol'=>'Br',
                       'subunit'=>'Kapyeyka',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'974'),
                    array('priority'=>'100',
                       'iso_code'=>'BZD',
                       'name'=>'Belize Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'084'),
                    array('priority'=>'5',
                       'iso_code'=>'CAD',
                       'name'=>'Canadian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'124'),
                    array('priority'=>'100',
                       'iso_code'=>'CDF',
                       'name'=>'Congolese Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'976'),
                    array('priority'=>'100',
                       'iso_code'=>'CHF',
                       'name'=>'Swiss Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Rappen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'756'),
                    array('priority'=>'100',
                       'iso_code'=>'CLF',
                       'name'=>'Unidad de Fomento',
                       'symbol'=>'UF',
                       'subunit'=>'Peso',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'990'),
                    array('priority'=>'100',
                       'iso_code'=>'CLP',
                       'name'=>'Chilean Peso',
                       'symbol'=>'$',
                       'subunit'=>'Peso',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#36;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'152'),
                    array('priority'=>'100',
                       'iso_code'=>'CNY',
                       'name'=>'Chinese Renminbi Yuan',
                       'symbol'=>'¥',
                       'subunit'=>'Fen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#20803;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'156'),
                    array('priority'=>'100',
                       'iso_code'=>'COP',
                       'name'=>'Colombian Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'170'),
                    array('priority'=>'100',
                       'iso_code'=>'CRC',
                       'name'=>'Costa Rican Colón',
                       'symbol'=>'₡',
                       'subunit'=>'Céntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'188'),
                    array('priority'=>'100',
                       'iso_code'=>'CUC',
                       'name'=>'Cuban Convertible Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'931'),
                    array('priority'=>'100',
                       'iso_code'=>'CUP',
                       'name'=>'Cuban Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'192'),
                    array('priority'=>'100',
                       'iso_code'=>'CVE',
                       'name'=>'Cape Verdean Escudo',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'132'),
                    array('priority'=>'100',
                       'iso_code'=>'CZK',
                       'name'=>'Czech Koruna',
                       'symbol'=>'Kč',
                       'subunit'=>'Haléř',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'203'),
                    array('priority'=>'100',
                       'iso_code'=>'DJF',
                       'name'=>'Djiboutian Franc',
                       'symbol'=>'Fdj',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'262'),
                    array('priority'=>'100',
                       'iso_code'=>'DKK',
                       'name'=>'Danish Krone',
                       'symbol'=>'kr',
                       'subunit'=>'Øre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'208'),
                    array('priority'=>'100',
                       'iso_code'=>'DOP',
                       'name'=>'Dominican Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'214'),
                    array('priority'=>'100',
                       'iso_code'=>'DZD',
                       'name'=>'Algerian Dinar',
                       'symbol'=>'د.ج',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'012'),
                    array('priority'=>'100',
                       'iso_code'=>'EGP',
                       'name'=>'Egyptian Pound',
                       'symbol'=>'ج.م',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'818'),
                    array('priority'=>'100',
                       'iso_code'=>'ERN',
                       'name'=>'Eritrean Nakfa',
                       'symbol'=>'Nfk',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'232'),
                    array('priority'=>'100',
                       'iso_code'=>'ETB',
                       'name'=>'Ethiopian Birr',
                       'symbol'=>'Br',
                       'subunit'=>'Santim',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'230'),
                    array('priority'=>'2',
                       'iso_code'=>'EUR',
                       'name'=>'Euro',
                       'symbol'=>'€',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20AC;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'978'),
                    array('priority'=>'100',
                       'iso_code'=>'FJD',
                       'name'=>'Fijian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'242'),
                    array('priority'=>'100',
                       'iso_code'=>'FKP',
                       'name'=>'Falkland Pound',
                       'symbol'=>'£',
                       'subunit'=>'Penny',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'238'),
                    array('priority'=>'3',
                       'iso_code'=>'GBP',
                       'name'=>'British Pound',
                       'symbol'=>'£',
                       'subunit'=>'Penny',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'826'),
                    array('priority'=>'100',
                       'iso_code'=>'GEL',
                       'name'=>'Georgian Lari',
                       'symbol'=>'ლ',
                       'subunit'=>'Tetri',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'981'),
                    array('priority'=>'100',
                       'iso_code'=>'GHS',
                       'name'=>'Ghanaian Cedi',
                       'symbol'=>'₵',
                       'subunit'=>'Pesewa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B5;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'936'),
                    array('priority'=>'100',
                       'iso_code'=>'GIP',
                       'name'=>'Gibraltar Pound',
                       'symbol'=>'£',
                       'subunit'=>'Penny',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'292'),
                    array('priority'=>'100',
                       'iso_code'=>'GMD',
                       'name'=>'Gambian Dalasi',
                       'symbol'=>'D',
                       'subunit'=>'Butut',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'270'),
                    array('priority'=>'100',
                       'iso_code'=>'GNF',
                       'name'=>'Guinean Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'324'),
                    array('priority'=>'100',
                       'iso_code'=>'GTQ',
                       'name'=>'Guatemalan Quetzal',
                       'symbol'=>'Q',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'320'),
                    array('priority'=>'100',
                       'iso_code'=>'GYD',
                       'name'=>'Guyanese Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'328'),
                    array('priority'=>'100',
                       'iso_code'=>'HKD',
                       'name'=>'Hong Kong Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'344'),
                    array('priority'=>'100',
                       'iso_code'=>'HNL',
                       'name'=>'Honduran Lempira',
                       'symbol'=>'L',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'340'),
                    array('priority'=>'100',
                       'iso_code'=>'HRK',
                       'name'=>'Croatian Kuna',
                       'symbol'=>'kn',
                       'subunit'=>'Lipa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'191'),
                    array('priority'=>'100',
                       'iso_code'=>'HTG',
                       'name'=>'Haitian Gourde',
                       'symbol'=>'G',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'332'),
                    array('priority'=>'100',
                       'iso_code'=>'HUF',
                       'name'=>'Hungarian Forint',
                       'symbol'=>'Ft',
                       'subunit'=>'Fillér',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'348'),
                    array('priority'=>'100',
                       'iso_code'=>'IDR',
                       'name'=>'Indonesian Rupiah',
                       'symbol'=>'Rp',
                       'subunit'=>'Sen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'360'),
                    array('priority'=>'100',
                       'iso_code'=>'ILS',
                       'name'=>'Israeli New Sheqel',
                       'symbol'=>'₪',
                       'subunit'=>'Agora',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20AA;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'376'),
                    array('priority'=>'100',
                       'iso_code'=>'INR',
                       'name'=>'Indian Rupee',
                       'symbol'=>'₹',
                       'subunit'=>'Paisa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20b9;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'356'),
                    array('priority'=>'100',
                       'iso_code'=>'IQD',
                       'name'=>'Iraqi Dinar',
                       'symbol'=>'ع.د',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'368'),
                    array('priority'=>'100',
                       'iso_code'=>'IRR',
                       'name'=>'Iranian Rial',
                       'symbol'=>'﷼',
                       'subunit'=>'Dinar',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'364'),
                    array('priority'=>'100',
                       'iso_code'=>'ISK',
                       'name'=>'Icelandic Króna',
                       'symbol'=>'kr',
                       'subunit'=>'Eyrir',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'352'),
                    array('priority'=>'100',
                       'iso_code'=>'JMD',
                       'name'=>'Jamaican Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'388'),
                    array('priority'=>'100',
                       'iso_code'=>'JOD',
                       'name'=>'Jordanian Dinar',
                       'symbol'=>'د.ا',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'400'),
                    array('priority'=>'6',
                       'iso_code'=>'JPY',
                       'name'=>'Japanese Yen',
                       'symbol'=>'¥',
                       'subunit'=>'null',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A5;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'392'),
                    array('priority'=>'100',
                       'iso_code'=>'KES',
                       'name'=>'Kenyan Shilling',
                       'symbol'=>'KSh',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'404'),
                    array('priority'=>'100',
                       'iso_code'=>'KGS',
                       'name'=>'Kyrgyzstani Som',
                       'symbol'=>'som',
                       'subunit'=>'Tyiyn',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'417'),
                    array('priority'=>'100',
                       'iso_code'=>'KHR',
                       'name'=>'Cambodian Riel',
                       'symbol'=>'៛',
                       'subunit'=>'Sen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x17DB;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'116'),
                    array('priority'=>'100',
                       'iso_code'=>'KMF',
                       'name'=>'Comorian Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'174'),
                    array('priority'=>'100',
                       'iso_code'=>'KPW',
                       'name'=>'North Korean Won',
                       'symbol'=>'₩',
                       'subunit'=>'Chŏn',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20A9;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'408'),
                    array('priority'=>'100',
                       'iso_code'=>'KRW',
                       'name'=>'South Korean Won',
                       'symbol'=>'₩',
                       'subunit'=>'null',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A9;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'410'),
                    array('priority'=>'100',
                       'iso_code'=>'KWD',
                       'name'=>'Kuwaiti Dinar',
                       'symbol'=>'د.ك',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'414'),
                    array('priority'=>'100',
                       'iso_code'=>'KYD',
                       'name'=>'Cayman Islands Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'136'),
                    array('priority'=>'100',
                       'iso_code'=>'KZT',
                       'name'=>'Kazakhstani Tenge',
                       'symbol'=>'〒',
                       'subunit'=>'Tiyn',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'398'),
                    array('priority'=>'100',
                       'iso_code'=>'LAK',
                       'name'=>'Lao Kip',
                       'symbol'=>'₭',
                       'subunit'=>'Att',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20AD;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'418'),
                    array('priority'=>'100',
                       'iso_code'=>'LBP',
                       'name'=>'Lebanese Pound',
                       'symbol'=>'ل.ل',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'422'),
                    array('priority'=>'100',
                       'iso_code'=>'LKR',
                       'name'=>'Sri Lankan Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x0BF9;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'144'),
                    array('priority'=>'100',
                       'iso_code'=>'LRD',
                       'name'=>'Liberian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'430'),
                    array('priority'=>'100',
                       'iso_code'=>'LSL',
                       'name'=>'Lesotho Loti',
                       'symbol'=>'L',
                       'subunit'=>'Sente',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'426'),
                    array('priority'=>'100',
                       'iso_code'=>'LTL',
                       'name'=>'Lithuanian Litas',
                       'symbol'=>'Lt',
                       'subunit'=>'Centas',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'440'),
                    array('priority'=>'100',
                       'iso_code'=>'LVL',
                       'name'=>'Latvian Lats',
                       'symbol'=>'Ls',
                       'subunit'=>'Santīms',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'428'),
                    array('priority'=>'100',
                       'iso_code'=>'LYD',
                       'name'=>'Libyan Dinar',
                       'symbol'=>'ل.د',
                       'subunit'=>'Dirham',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'434'),
                    array('priority'=>'100',
                       'iso_code'=>'MAD',
                       'name'=>'Moroccan Dirham',
                       'symbol'=>'د.م.',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'504'),
                    array('priority'=>'100',
                       'iso_code'=>'MDL',
                       'name'=>'Moldovan Leu',
                       'symbol'=>'L',
                       'subunit'=>'Ban',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'498'),
                    array('priority'=>'100',
                       'iso_code'=>'MGA',
                       'name'=>'Malagasy Ariary',
                       'symbol'=>'Ar',
                       'subunit'=>'Iraimbilanja',
                       'subunit_to_unit'=>'5',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'969'),
                    array('priority'=>'100',
                       'iso_code'=>'MKD',
                       'name'=>'Macedonian Denar',
                       'symbol'=>'ден',
                       'subunit'=>'Deni',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'807'),
                    array('priority'=>'100',
                       'iso_code'=>'MMK',
                       'name'=>'Myanmar Kyat',
                       'symbol'=>'K',
                       'subunit'=>'Pya',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'104'),
                    array('priority'=>'100',
                       'iso_code'=>'MNT',
                       'name'=>'Mongolian Tögrög',
                       'symbol'=>'₮',
                       'subunit'=>'Möngö',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20AE;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'496'),
                    array('priority'=>'100',
                       'iso_code'=>'MOP',
                       'name'=>'Macanese Pataca',
                       'symbol'=>'P',
                       'subunit'=>'Avo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'446'),
                    array('priority'=>'100',
                       'iso_code'=>'MRO',
                       'name'=>'Mauritanian Ouguiya',
                       'symbol'=>'UM',
                       'subunit'=>'Khoums',
                       'subunit_to_unit'=>'5',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'478'),
                    array('priority'=>'100',
                       'iso_code'=>'MUR',
                       'name'=>'Mauritian Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A8;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'480'),
                    array('priority'=>'100',
                       'iso_code'=>'MVR',
                       'name'=>'Maldivian Rufiyaa',
                       'symbol'=>'MVR',
                       'subunit'=>'Laari',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'462'),
                    array('priority'=>'100',
                       'iso_code'=>'MWK',
                       'name'=>'Malawian Kwacha',
                       'symbol'=>'MK',
                       'subunit'=>'Tambala',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'454'),
                    array('priority'=>'100',
                       'iso_code'=>'MXN',
                       'name'=>'Mexican Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'484'),
                    array('priority'=>'100',
                       'iso_code'=>'MYR',
                       'name'=>'Malaysian Ringgit',
                       'symbol'=>'RM',
                       'subunit'=>'Sen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'458'),
                    array('priority'=>'100',
                       'iso_code'=>'MZN',
                       'name'=>'Mozambican Metical',
                       'symbol'=>'MTn',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'943'),
                    array('priority'=>'100',
                       'iso_code'=>'NAD',
                       'name'=>'Namibian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'516'),
                    array('priority'=>'100',
                       'iso_code'=>'NGN',
                       'name'=>'Nigerian Naira',
                       'symbol'=>'₦',
                       'subunit'=>'Kobo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20A6;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'566'),
                    array('priority'=>'100',
                       'iso_code'=>'NIO',
                       'name'=>'Nicaraguan Córdoba',
                       'symbol'=>'C$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'558'),
                    array('priority'=>'100',
                       'iso_code'=>'NOK',
                       'name'=>'Norwegian Krone',
                       'symbol'=>'kr',
                       'subunit'=>'Øre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'kr',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'578'),
                    array('priority'=>'100',
                       'iso_code'=>'NPR',
                       'name'=>'Nepalese Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Paisa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A8;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'524'),
                    array('priority'=>'100',
                       'iso_code'=>'NZD',
                       'name'=>'New Zealand Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'554'),
                    array('priority'=>'100',
                       'iso_code'=>'OMR',
                       'name'=>'Omani Rial',
                       'symbol'=>'ر.ع.',
                       'subunit'=>'Baisa',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'512'),
                    array('priority'=>'100',
                       'iso_code'=>'PAB',
                       'name'=>'Panamanian Balboa',
                       'symbol'=>'B/.',
                       'subunit'=>'Centésimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'590'),
                    array('priority'=>'100',
                       'iso_code'=>'PEN',
                       'name'=>'Peruvian Nuevo Sol',
                       'symbol'=>'S/.',
                       'subunit'=>'Céntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'S/.',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'604'),
                    array('priority'=>'100',
                       'iso_code'=>'PGK',
                       'name'=>'Papua New Guinean Kina',
                       'symbol'=>'K',
                       'subunit'=>'Toea',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'598'),
                    array('priority'=>'100',
                       'iso_code'=>'PHP',
                       'name'=>'Philippine Peso',
                       'symbol'=>'₱',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'608'),
                    array('priority'=>'100',
                       'iso_code'=>'PKR',
                       'name'=>'Pakistani Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Paisa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A8;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'586'),
                    array('priority'=>'100',
                       'iso_code'=>'PLN',
                       'name'=>'Polish Złoty',
                       'symbol'=>'zł',
                       'subunit'=>'Grosz',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'z&#322;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'',
                       'iso_numeric'=>'985'),
                    array('priority'=>'100',
                       'iso_code'=>'PYG',
                       'name'=>'Paraguayan Guaraní',
                       'symbol'=>'₲',
                       'subunit'=>'Céntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B2;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'600'),
                    array('priority'=>'100',
                       'iso_code'=>'QAR',
                       'name'=>'Qatari Riyal',
                       'symbol'=>'ر.ق',
                       'subunit'=>'Dirham',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'634'),
                    array('priority'=>'100',
                       'iso_code'=>'RON',
                       'name'=>'Romanian Leu',
                       'symbol'=>'Lei',
                       'subunit'=>'Bani',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'946'),
                    array('priority'=>'100',
                       'iso_code'=>'RSD',
                       'name'=>'Serbian Dinar',
                       'symbol'=>'РСД',
                       'subunit'=>'Para',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'941'),
                    array('priority'=>'100',
                       'iso_code'=>'RUB',
                       'name'=>'Russian Ruble',
                       'symbol'=>'р.',
                       'subunit'=>'Kopek',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x0440;&#x0443;&#x0431;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'643'),
                    array('priority'=>'100',
                       'iso_code'=>'RWF',
                       'name'=>'Rwandan Franc',
                       'symbol'=>'FRw',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'646'),
                    array('priority'=>'100',
                       'iso_code'=>'SAR',
                       'name'=>'Saudi Riyal',
                       'symbol'=>'ر.س',
                       'subunit'=>'Hallallah',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'682'),
                    array('priority'=>'100',
                       'iso_code'=>'SBD',
                       'name'=>'Solomon Islands Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'090'),
                    array('priority'=>'100',
                       'iso_code'=>'SCR',
                       'name'=>'Seychellois Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20A8;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'690'),
                    array('priority'=>'100',
                       'iso_code'=>'SDG',
                       'name'=>'Sudanese Pound',
                       'symbol'=>'£',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'938'),
                    array('priority'=>'100',
                       'iso_code'=>'SEK',
                       'name'=>'Swedish Krona',
                       'symbol'=>'kr',
                       'subunit'=>'Öre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'',
                       'iso_numeric'=>'752'),
                    array('priority'=>'100',
                       'iso_code'=>'SGD',
                       'name'=>'Singapore Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'702'),
                    array('priority'=>'100',
                       'iso_code'=>'SHP',
                       'name'=>'Saint Helenian Pound',
                       'symbol'=>'£',
                       'subunit'=>'Penny',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'654'),
                    array('priority'=>'100',
                       'iso_code'=>'SKK',
                       'name'=>'Slovak Koruna',
                       'symbol'=>'Sk',
                       'subunit'=>'Halier',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'703'),
                    array('priority'=>'100',
                       'iso_code'=>'SLL',
                       'name'=>'Sierra Leonean Leone',
                       'symbol'=>'Le',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'694'),
                    array('priority'=>'100',
                       'iso_code'=>'SOS',
                       'name'=>'Somali Shilling',
                       'symbol'=>'Sh',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'706'),
                    array('priority'=>'100',
                       'iso_code'=>'SRD',
                       'name'=>'Surinamese Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'968'),
                    array('priority'=>'100',
                       'iso_code'=>'SSP',
                       'name'=>'South Sudanese Pound',
                       'symbol'=>'£',
                       'subunit'=>'piaster',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'728'),
                    array('priority'=>'100',
                       'iso_code'=>'STD',
                       'name'=>'São Tomé and Príncipe Dobra',
                       'symbol'=>'Db',
                       'subunit'=>'Cêntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'678'),
                    array('priority'=>'100',
                       'iso_code'=>'SVC',
                       'name'=>'Salvadoran Colón',
                       'symbol'=>'₡',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A1;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'222'),
                    array('priority'=>'100',
                       'iso_code'=>'SYP',
                       'name'=>'Syrian Pound',
                       'symbol'=>'£S',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'760'),
                    array('priority'=>'100',
                       'iso_code'=>'SZL',
                       'name'=>'Swazi Lilangeni',
                       'symbol'=>'L',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'748'),
                    array('priority'=>'100',
                       'iso_code'=>'THB',
                       'name'=>'Thai Baht',
                       'symbol'=>'฿',
                       'subunit'=>'Satang',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x0E3F;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'764'),
                    array('priority'=>'100',
                       'iso_code'=>'TJS',
                       'name'=>'Tajikistani Somoni',
                       'symbol'=>'ЅМ',
                       'subunit'=>'Diram',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'972'),
                    array('priority'=>'100',
                       'iso_code'=>'TMT',
                       'name'=>'Turkmenistani Manat',
                       'symbol'=>'T',
                       'subunit'=>'Tenge',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'934'),
                    array('priority'=>'100',
                       'iso_code'=>'TND',
                       'name'=>'Tunisian Dinar',
                       'symbol'=>'د.ت',
                       'subunit'=>'Millime',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'788'),
                    array('priority'=>'100',
                       'iso_code'=>'TOP',
                       'name'=>'Tongan Paʻanga',
                       'symbol'=>'T$',
                       'subunit'=>'Seniti',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'776'),
                    array('priority'=>'100',
                       'iso_code'=>'TRY',
                       'name'=>'Turkish Lira',
                       'symbol'=>'TL',
                       'subunit'=>'kuruş',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'949'),
                    array('priority'=>'100',
                       'iso_code'=>'TTD',
                       'name'=>'Trinidad and Tobago Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'780'),
                    array('priority'=>'100',
                       'iso_code'=>'TWD',
                       'name'=>'New Taiwan Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'901'),
                    array('priority'=>'100',
                       'iso_code'=>'TZS',
                       'name'=>'Tanzanian Shilling',
                       'symbol'=>'Sh',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'834'),
                    array('priority'=>'100',
                       'iso_code'=>'UAH',
                       'name'=>'Ukrainian Hryvnia',
                       'symbol'=>'₴',
                       'subunit'=>'Kopiyka',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20B4;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'980'),
                    array('priority'=>'100',
                       'iso_code'=>'UGX',
                       'name'=>'Ugandan Shilling',
                       'symbol'=>'USh',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'800'),
                    array('priority'=>'1',
                       'iso_code'=>'USD',
                       'name'=>'United States Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'840'),
                    array('priority'=>'100',
                       'iso_code'=>'UYU',
                       'name'=>'Uruguayan Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centésimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'858'),
                    array('priority'=>'100',
                       'iso_code'=>'UZS',
                       'name'=>'Uzbekistani Som',
                       'symbol'=>'null',
                       'subunit'=>'Tiyin',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'860'),
                    array('priority'=>'100',
                       'iso_code'=>'VEF',
                       'name'=>'Venezuelan Bolívar',
                       'symbol'=>'Bs F',
                       'subunit'=>'Céntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'937'),
                    array('priority'=>'100',
                       'iso_code'=>'VND',
                       'name'=>'Vietnamese Đồng',
                       'symbol'=>'₫',
                       'subunit'=>'Hào',
                       'subunit_to_unit'=>'10',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20AB;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'704'),
                    array('priority'=>'100',
                       'iso_code'=>'VUV',
                       'name'=>'Vanuatu Vatu',
                       'symbol'=>'Vt',
                       'subunit'=>'null',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'548'),
                    array('priority'=>'100',
                       'iso_code'=>'WST',
                       'name'=>'Samoan Tala',
                       'symbol'=>'T',
                       'subunit'=>'Sene',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'882'),
                    array('priority'=>'100',
                       'iso_code'=>'XAF',
                       'name'=>'Central African Cfa Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'950'),
                    array('priority'=>'100',
                       'iso_code'=>'XAG',
                       'name'=>'Silver (Troy Ounce)',
                       'symbol'=>'oz t',
                       'subunit'=>'oz',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'961'),
                    array('priority'=>'100',
                       'iso_code'=>'XAU',
                       'name'=>'Gold (Troy Ounce)',
                       'symbol'=>'oz t',
                       'subunit'=>'oz',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'959'),
                    array('priority'=>'100',
                       'iso_code'=>'XCD',
                       'name'=>'East Caribbean Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'951'),
                    array('priority'=>'100',
                       'iso_code'=>'XDR',
                       'name'=>'Special Drawing Rights',
                       'symbol'=>'SDR',
                       'subunit'=>'',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'960'),
                    array('priority'=>'100',
                       'iso_code'=>'XOF',
                       'name'=>'West African Cfa Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'952'),
                    array('priority'=>'100',
                       'iso_code'=>'XPF',
                       'name'=>'Cfp Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'953'),
                    array('priority'=>'100',
                       'iso_code'=>'YER',
                       'name'=>'Yemeni Rial',
                       'symbol'=>'﷼',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'886'),
                    array('priority'=>'100',
                       'iso_code'=>'ZAR',
                       'name'=>'South African Rand',
                       'symbol'=>'R',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x0052;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'710'),
                    array('priority'=>'100',
                       'iso_code'=>'ZMK',
                       'name'=>'Zambian Kwacha',
                       'symbol'=>'ZK',
                       'subunit'=>'Ngwee',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'894'),
                    array('priority'=>'100',
                       'iso_code'=>'ZMW',
                       'name'=>'Zambian Kwacha',
                       'symbol'=>'ZK',
                       'subunit'=>'Ngwee',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'967')
        ));
    }
}
